/*
 * Decompiled with CFR 0.152.
 */
package server.restful.common;

import client.teavm.common.parameter.StringBuilderConsole;
import client.teavm.common.parameter.event.ExportEventParameters;
import client.teavm.common.parameter.usage.EventDiscriminatorUsageFormatter;
import com.beust.jcommander.Parameters;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.inject.Inject;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.IOUtils;
import libsidutils.siddatabase.SidDatabase;
import libsidutils.stil.STIL;
import server.restful.common.ContentTypeAndFileExtensions;
import server.restful.common.ServletUtil;
import server.restful.common.converter.WebResourceConverter;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.UsageParameter;
import sidplay.filefilter.AudioTuneFileFilter;
import sidplay.filefilter.VideoTuneFileFilter;
import ui.common.filefilter.CartFileFilter;
import ui.common.filefilter.DiskFileFilter;
import ui.common.filefilter.TapeFileFilter;
import ui.entities.config.Configuration;

public abstract class JSIDPlay2Servlet
extends HttpServlet {
    public static final AudioTuneFileFilter AUDIO_TUNE_FILE_FILTER = new AudioTuneFileFilter();
    public static final VideoTuneFileFilter VIDEO_TUNE_FILE_FILTER = new VideoTuneFileFilter();
    public static final DiskFileFilter DISK_FILE_FILTER = new DiskFileFilter();
    public static final TapeFileFilter TAPE_FILE_FILTER = new TapeFileFilter();
    public static final CartFileFilter CART_FILE_FILTER = new CartFileFilter();
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    public static final String C64_MUSIC = "/C64Music";
    public static final String CGSC = "/CGSC";
    protected static final String SERVLET_PATH = "<ServletPath>";
    public static final String DEV_TOOLS_SECTION1 = IOUtils.convertStreamToString(new WebResourceConverter("<ServletPath>").convert("/teavm/devtools_section_1.js"), StandardCharsets.UTF_8);
    public static final String DEV_TOOLS_SECTION2 = IOUtils.convertStreamToString(new WebResourceConverter("<ServletPath>").convert("/teavm/devtools_section_2.js"), StandardCharsets.UTF_8);
    public static final StringBuilder DISCRIMINATOR_PATH = new StringBuilder();
    @Inject
    protected Configuration configuration;
    @Inject
    protected SidDatabase sidDatabase;
    @Inject
    protected STIL stil;
    @Inject
    protected Properties directoryProperties;

    public Map<Class<? extends HttpFilter>, Map<String, String>> getServletFiltersParameterMap() {
        return Collections.emptyMap();
    }

    protected boolean hasAdminAccess(HttpServletRequest request) {
        ServletSecurity servletSecurity = ((Object)((Object)this)).getClass().getAnnotation(ServletSecurity.class);
        return !ServletUtil.isSecured(servletSecurity) || request.isUserInRole("admin");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PureUsageParameter servletParameters = new PureUsageParameter();
        new ServletParameterParser(request, response, servletParameters, true);
        if (servletParameters.getHelp().booleanValue()) {
            this.doPost((HttpServletRequest)new HttpServletRequestWrapper(request){

                public String getMethod() {
                    return "POST";
                }
            }, response);
        } else {
            super.doGet(request, response);
        }
    }

    protected String getCollectionName(File file) throws IOException, SidTuneError {
        String result = "";
        File hvscRoot = this.configuration.getSidplay2Section().getHvsc();
        if (hvscRoot != null && (result = IOUtils.getCollectionName(hvscRoot, file)).isEmpty()) {
            result = this.sidDatabase != null ? this.sidDatabase.getPath(SidTune.load(file)) : "";
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T getInput(HttpServletRequest request, Class<T> tClass) throws IOException {
        try (ServletInputStream inputStream = request.getInputStream();){
            String contentType = request.getContentType();
            if (contentType == null || ContentTypeAndFileExtensions.MIME_TYPE_JSON.isCompatible(contentType)) {
                Object object = OBJECT_MAPPER.readValue((InputStream)inputStream, tClass);
                return (T)object;
            }
            if (ContentTypeAndFileExtensions.MIME_TYPE_XML.isCompatible(contentType)) {
                Object object = JAXBContext.newInstance((Class[])new Class[]{tClass}).createUnmarshaller().unmarshal((Source)new StreamSource(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8.name())), tClass).getValue();
                return (T)object;
            }
            Iterator iterator = request.getParts().iterator();
            if (!iterator.hasNext()) throw new IOException("Upload without content!");
            Part part = (Part)iterator.next();
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            try (InputStream itemInputStream = part.getInputStream();){
                IOUtils.copy(itemInputStream, result);
            }
            T t = tClass.getConstructor(byte[].class).newInstance(new Object[]{result.toByteArray()});
            return t;
        }
        catch (ServletException | IOException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | JAXBException e) {
            throw new IOException(e);
        }
    }

    protected void setOutput(HttpServletRequest request, HttpServletResponse response, Object result) {
        block4: {
            try {
                Optional optionalContentType = Optional.ofNullable(request.getHeader("Accept")).map(accept -> Arrays.asList(accept.split(","))).orElse(Collections.emptyList()).stream().findFirst();
                if (!optionalContentType.isPresent() || ContentTypeAndFileExtensions.MIME_TYPE_JSON.isCompatible((String)optionalContentType.get())) {
                    this.setOutput(ContentTypeAndFileExtensions.MIME_TYPE_JSON, response, result);
                    break block4;
                }
                if (ContentTypeAndFileExtensions.MIME_TYPE_XML.isCompatible((String)optionalContentType.get())) {
                    this.setOutput(ContentTypeAndFileExtensions.MIME_TYPE_XML, response, result);
                    break block4;
                }
                throw new IOException(String.format("Unsupported content type: %s!", optionalContentType.get()));
            }
            catch (IOException e) {
                ServletUtil.error(this.getServletContext(), e, new Thread[0]);
            }
        }
    }

    protected void setOutput(ContentTypeAndFileExtensions ct, HttpServletResponse response, Object result) {
        block11: {
            if (result == null) {
                return;
            }
            try (ServletOutputStream out = response.getOutputStream();){
                if (ContentTypeAndFileExtensions.MIME_TYPE_JSON.isCompatible(ct.toString())) {
                    response.setContentType(ContentTypeAndFileExtensions.MIME_TYPE_JSON.toString());
                    OBJECT_MAPPER.writeValue((OutputStream)out, result);
                    break block11;
                }
                if (ContentTypeAndFileExtensions.MIME_TYPE_XML.isCompatible(ct.toString())) {
                    response.setContentType(ContentTypeAndFileExtensions.MIME_TYPE_XML.toString());
                    JAXBContext.newInstance((Class[])new Class[]{result.getClass()}).createMarshaller().marshal(result, (OutputStream)out);
                    break block11;
                }
                throw new IOException(String.format("Unsupported content type: %s!", new Object[]{ct}));
            }
            catch (IOException | JAXBException e) {
                ServletUtil.error(this.getServletContext(), e, new Thread[0]);
            }
        }
    }

    protected void setOutput(ContentTypeAndFileExtensions ct, HttpServletResponse response, InputStream is) {
        if (is == null) {
            return;
        }
        try (ServletOutputStream out = response.getOutputStream();){
            response.setContentType(ct.toString());
            IOUtils.copy(is, (OutputStream)out);
        }
        catch (IOException e) {
            ServletUtil.error(this.getServletContext(), e, new Thread[0]);
        }
    }

    protected void setOutput(HttpServletResponse response, Throwable t) {
        this.setOutput(ContentTypeAndFileExtensions.MIME_TYPE_TEXT, response, t.getClass().getSimpleName() + ": " + t.getMessage());
    }

    protected void setOutput(ContentTypeAndFileExtensions ct, HttpServletResponse response, String message) {
        response.setContentType(ct.toString());
        try (PrintStream out = new PrintStream((OutputStream)response.getOutputStream(), true, Optional.ofNullable(ct.getCharset()).map(Charset::toString).orElse(StandardCharsets.UTF_8.name()));){
            out.print(message);
        }
        catch (IOException e) {
            ServletUtil.error(this.getServletContext(), e, new Thread[0]);
        }
    }

    static {
        ExportEventParameters.usage(new StringBuilderConsole(DISCRIMINATOR_PATH), EventDiscriminatorUsageFormatter::new);
    }

    @Parameters(resourceBundle="server.restful.common.UsageParameter")
    public class PureUsageParameter
    extends UsageParameter {
    }
}

